/*
 * Decompiled with CFR 0.152.
 */
package android.net.fourG.wimax;

import android.os.Parcel;
import android.os.Parcelable;

public class DeviceStatusInfo
implements Parcelable {
    private int mDeviceStatus;
    private int mConnectionProgressInfo;
    private int mStatusReason;
    public static final Parcelable.Creator<DeviceStatusInfo> CREATOR = new Parcelable.Creator<DeviceStatusInfo>(){

        public DeviceStatusInfo createFromParcel(Parcel in) {
            int deviceStatus = in.readInt();
            int statusReason = in.readInt();
            int connectionProgressInfo = in.readInt();
            DeviceStatusInfo deviceStatusInfo = new DeviceStatusInfo(deviceStatus, statusReason, connectionProgressInfo);
            return deviceStatusInfo;
        }

        public DeviceStatusInfo[] newArray(int size) {
            return new DeviceStatusInfo[size];
        }
    };

    public DeviceStatusInfo() {
    }

    DeviceStatusInfo(int deviceStatus, int statusReason, int connectionProgressInfo) {
        this.setDeviceStatus(deviceStatus, statusReason, connectionProgressInfo);
    }

    public DeviceStatus getDeviceStatus() {
        for (DeviceStatus eDeviceStatus : DeviceStatus.values()) {
            if (eDeviceStatus.ordinal() != this.mDeviceStatus) continue;
            return eDeviceStatus;
        }
        return null;
    }

    void setDeviceStatus(int deviceStatus, int statusReason, int connectionProgressInfo) {
        this.mDeviceStatus = deviceStatus;
        this.mStatusReason = statusReason;
        this.mConnectionProgressInfo = connectionProgressInfo;
    }

    public StatusReason getStatusReason() {
        for (StatusReason eStatusReason : StatusReason.values()) {
            if (eStatusReason.ordinal() != this.mStatusReason) continue;
            return eStatusReason;
        }
        return null;
    }

    public ConnectionProgressInfo getConnectionProgressInfo() {
        for (ConnectionProgressInfo eInfo : ConnectionProgressInfo.values()) {
            if (eInfo.ordinal() != this.mConnectionProgressInfo) continue;
            return eInfo;
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("DeviceStatusInfo: ");
        builder.append("DeviceStatus: ").append(this.mDeviceStatus).append(", StatusReason: ").append(this.mStatusReason).append(", ConnectionProgressInfo: ").append(this.mConnectionProgressInfo);
        return builder.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mDeviceStatus);
        dest.writeInt(this.mStatusReason);
        dest.writeInt(this.mConnectionProgressInfo);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConnectionProgressInfo {
        Ranging,
        SBC,
        PKM,
        Registration,
        DSX,
        Registered,
        Idle,
        IP_Renew,
        De_registration,
        Syncup_PHY,
        Syncup_MAC,
        EAP_authentication_Device,
        EAP_authentication_User,
        Timeout_Sync,
        Timeout_NE,
        Timeout_NDREG,
        IP_USB,
        CONNECTED_USB,
        RESUME_USB,
        SUSPEND_USB,
        Met_Exit_Criteria,
        Not_Met_Entry_Criteria,
        Abnormal_State,
        DISCONNECTED_USB;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatusReason {
        Normal,
        Fail;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeviceStatus {
        UnInitialized,
        RF_OFF_HW_SW,
        RF_OFF_HW,
        RF_OFF_SW,
        Initialized,
        Scanning,
        Ready,
        Connecting,
        Data_Connected,
        Disconnecting,
        Disconnected;

    }
}

