#!/sbin/sh

if [ "$?" != "0" ]; then busybox dos2unix $0;sh $0;exit;fi;
# original by Effdee
# http://forum.xda-developers.com/attachment.php?attachmentid=578753&d=1303827869
#
# Modified by Firerat 2011-10-01
# heavily modified by Firerat 2011-10-03
# replaced the build.prop lcd density lookup with a strings thing, > hits < misses, Firerat 2011-10-12
status="/tmp/patch/patchstatus.log"

for i in mount find grep awk basename strings;do
    alias $i="busybox $i"
done

mount /system

if [ "`grep -q \/system\  /proc/mounts ; echo $?`" != "0" ];
then
    echo "status=fail" > $status
    echo "info1=Failed to mount /system." >> $status
    echo "info2=Terminating installation." >> $status
    exit 1
fi

dpi=0
apklisting=""
for patch in `find /tmp/patch/ -type d -name "*.apk"`;do
    apk=`basename $patch`
    patchee=`find /system -name $apk`
    if [ "$patchee" = "" ];
    then
        apklisting=""
        break
    else
        apklisting="`strings $patchee | awk -FPK '/PK$/ {printf $1" "}'`"
		dpi=$(($dpi+1))
    fi

    cd $patch
    /tmp/patch/zip -r $patchee `ls`
    apklist="$apk $apklist"
    cd /tmp/patch
done
unmount /system

echo "status=pass" > $status
echo "info1=Done." >> $status
echo "info2=The following $dpi file(s) successfully patched:" >> $status
echo "info3=$apklist" >> $status
