package oemMaker;

import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Parameters
{
	private static final Pattern CHECK_FOR_CE = Pattern.compile("^CE",
			Pattern.CASE_INSENSITIVE);
	private static final Pattern LOCATE_VARIABLE = Pattern.compile("%([^%]+)%");
	private HashMap<String, String> parameters;

	// Initialize the vectors.
	public Parameters()
	{

		// Initialize them.
		parameters = new HashMap<String, String>();

		// Add the default values.
		put("CE1", "\\Program Files");
		put("CE2", "\\Windows");
		put("CE3", "\\Windows\\Desktop");
		put("CE4", "\\Windows\\StartUp");
		put("CE5", "\\My Documents");
		put("CE6", "\\Program Files\\Accessories");
		put("CE7", "\\Program Files\\Communications");
		put("CE8", "\\Program Files\\Games");
		put("CE9", "\\Program Files\\Pocket Outlook");
		put("CE10", "\\Program Files\\Office");
		put("CE11", "\\Windows\\Start Menu\\Programs");
		put("CE12", "\\Windows\\Start Menu\\Programs\\Accessories");
		put("CE13", "\\Windows\\Start Menu\\Programs\\Communications");
		put("CE14", "\\Windows\\Start Menu\\Programs\\Games");
		put("CE15", "\\Windows\\Fonts");
		put("CE16", "\\Windows\\Recent");		
		put("CE17", "\\Windows\\Start Menu");
		put("CE18", "\\Windows");
		put("CE19", "\\Application Data");
	}

	// Finds the key at keyNumber.
	public String get(String key)
	{
		return parameters.get(key);
	}

	// Returns the length.
	public int length()
	{
		return parameters.size();
	}

	// Outputs the hashmap.
	public void outputParameters()
	{
		Iterator iterator = parameters.keySet().iterator();
		String key;
		int i = 1;
		while (iterator.hasNext())
		{
			key = (String) iterator.next();

			if (!CHECK_FOR_CE.matcher(key).find())
			{
				System.out.println(key + " => "
						+ parameters.get(key));
				i++;
			}
		}
	}

	// Add a parameter.
	public void put(String key, String value)
	{
		parameters.put(key, replaceVariables(value));
	}

	// Replaces all the %things%.
	public String replaceVariables(String value)
	{
		// Determine if there is a %blah%.
		Matcher matcher = LOCATE_VARIABLE.matcher(value);

		while (matcher.find())
		{
			// Replace it.
			if(parameters.get(matcher.group(1)) != null)
			{
				value = value.replaceFirst("%[^%]+%", parameters.get(
						matcher.group(1)).replace("\\", "\\\\"));				
			}
			else
			{
				System.out.println("Warning: Unknown variable " + matcher.group(1));
				value.replaceFirst("%[^%]+%", "unknownvariable");
			}
		}

		// Return it.
		return value;
	}

	// Set the value of the key number.
	public void set(String key, String value)
	{
		parameters.put(key, value);
	}
}
