package oemMaker;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.UUID;

import keyboardPackage.Keyboard;

public class OEMMaker
{	
	// Create a new OEMMaker.
	public static void main(String[] args) throws Exception
	{
		new OEMMaker(args);
	}

	// Make the OEM.
	public OEMMaker(String[] args)
	{
		if(args.length > 0)
		{
			// Get the cab filename.
			String cabFile = args[0];

			// Get the OEM name.
			System.out.print("What do you want to name the OEM's directory?: ");
			String oemName = Keyboard.readString();

			// If the cab extracts properly, get a guid and then determine what
			// to do.
			if(extractCab(cabFile, oemName))
			{
				String uuid = getUUID();
				executeCab(oemName, uuid);
				System.out.println("Completed!");
			}
		}
		// No cab argument.
		else
		{
			System.out.println("You didn't specify a cab file!");
		}
	}

	// Determine what type of cab it is and then do whatever.
	public void executeCab(String oemName, String uuid)
	{
		File origDirectory = new File(oemName + "\\orig\\");

		// Check if it extracted properly.
		if(origDirectory.exists())
		{
			// Determine what type of cab this is.
			// XML file type.
			if (origDirectory.listFiles(new FileFilter("", "setup.xml")).length > 0)
			{
				 new XMLCabType(oemName, uuid).processFile(origDirectory.listFiles(new FileFilter("", "setup.xml"))[0].getAbsolutePath());
			}
			// Binary file type.
			else if (origDirectory.listFiles(new FileFilter("", ".000")).length > 0)
			{
				new BinaryCabType(oemName, uuid).processFile(origDirectory.listFiles(new FileFilter("", ".000"))[0].getAbsolutePath());
			}
			// Something else.
			else
			{
				System.out.println("I have no idea what to do here.");
			}			
		}
		else
		{
			System.out.println("Cab extracted improperly.");
		}
	}

	// Extract the cab file.
	public boolean extractCab(String cabFile, String oemName)
	{
		// Check if the cab exists.
		if (new File(cabFile).exists() && new File("extract.exe").exists())
		{
			// Try to extract the cab.
			try
			{
				// Run the system command.
				Process extract = Runtime.getRuntime().exec(
								"extract.exe /E /Y /L " + oemName + "\\orig "
								+ cabFile);
				
				// This loops until the command finishes.
				BufferedReader reader = new BufferedReader(new InputStreamReader(extract.getInputStream()));
				while((reader.readLine()) != null);
				
				return true;
			}
			// Ut oh. Tell them the error.
			catch (IOException e)
			{
				System.out.println("Error when extracting cab.");
				return false;
			}
		}
		// It doesn't exist.
		else if(!new File(cabFile).exists())
		{
			System.out.println("Cab file does not exist.");
			return false;
		}
		// No extract.exe.
		else
		{
			System.out.println("Cannot find extract.exe.");
			return false;
		}
	}

	// Generate a uuid and then prompt the user to change it.
	public String getUUID()
	{
		// Create a base uuid.
		String uuid = UUID.randomUUID().toString();

		String tempUUID;
		boolean validUUID = false;
		while (!validUUID)
		{
			// Ask them if they want to change the uuid.
			System.out
					.println("I generated "
							+ uuid
							+ " for the uuid, press enter to keep this one or enter a new one here: ");
			tempUUID = Keyboard.readString();

			// If this is true, they want to keep the one made.
			if (tempUUID.equals(""))
			{
				validUUID = true;
			}
			// They tried to change it.
			else
			{
				// Valid the uuid.
				try
				{
					uuid = UUID.fromString(tempUUID).toString();
					validUUID = true;
				}
				// It's invalid.
				catch (IllegalArgumentException e)
				{
					System.out.print("That uuid is invalid. ");
				}
			}
		}

		return uuid;
	}
}
