package oemMaker;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

import keyboardPackage.Keyboard;

import sun.misc.BASE64Decoder;

public class CabType
{
	protected String oemName;
	protected String uuid;
	protected BufferedWriter initflashfiles;
	protected BufferedWriter rgu;
	protected BufferedWriter dsm;

	protected Parameters parameters = new Parameters();

	// Save the oemName and uuid, then create the other files.
	public CabType(String oemNameIn, String uuidIn)
	{
		// Save the variables.
		oemName = oemNameIn;
		uuid = uuidIn;

		// Open the 3 required files.
		try
		{
			initflashfiles = new BufferedWriter(new OutputStreamWriter(
					new FileOutputStream(oemName + "\\initflashfiles.txt"),
					"UTF-16LE"));
			initflashfiles.write(65279);
			initflashfiles.write("; " + oemName + "\r\n");

			rgu = new BufferedWriter(new OutputStreamWriter(
					new FileOutputStream(oemName + "\\" + uuid + ".rgu"),
					"UTF-16LE"));
			rgu.write(65279);
			rgu.write("REGEDIT4\r\n");

			dsm = new BufferedWriter(new OutputStreamWriter(
					new FileOutputStream(oemName + "\\" + uuid + ".dsm"),
					"US-ASCII"));
			dsm.close();
		}
		// Can't write in the encoding.
		catch (Exception e)
		{
			System.out.println("Cannot create the 3 required files.");
		}
	}
	
	// Creates a shortcut.
	protected static void createShortcut(String shortcut, String contents)
	{
		try
		{
			BufferedWriter shortcutStream = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(shortcut)));
			shortcutStream.write("41#\"" + contents + "\"");
			shortcutStream.close();
		}
		catch (Exception e)
		{
			System.out.println("Cannot create shortcut " + shortcut + " to " + contents + ".");
		}
	}

	// Recursively delete a directory, copied from Java Developer's Almanac.
	public static boolean deleteDir(File dir) {
		if (dir.isDirectory()) {
			String[] children = dir.list();
			for (int i=0; i<children.length; i++) {
				boolean success = deleteDir(new File(dir, children[i]));
				if (!success) {
					return false;
				}
			}
		}
		
		// The directory is now empty so delete it
		return dir.delete();
	}
	
	// Converts a string to hex string.
	// (Mostly) written by Roedy Green: mindprod.com
	protected static String toHexString(byte[] b)
	{
		char[] hexChar = { 
				'0' , '1' , '2' , '3' ,
				'4' , '5' , '6' , '7' ,
				'8' , '9' , 'a' , 'b' ,
				'c' , 'd' , 'e' , 'f'};

		StringBuffer sb = new StringBuffer(b.length * 2);
		for (int i = 0; i < b.length; i++)
		{
			// look up high nibble char
			sb.append(hexChar[(b[i] & 0xf0) >>> 4]);

			// look up low nibble char
			sb.append(hexChar[b[i] & 0x0f]);
			
			// add the comma.
			sb.append(",");
		}
		return sb.toString();
	}
	
	// Write command to the initflashfiles.txt.
	protected void writeInitFlashFile(String directory, String command)
	{
		try
		{
			initflashfiles.write("Directory(\"" + directory + "\"):-" + command
					+ "\r\n");
		}
		catch (IOException e)
		{
			System.out.println("Cannot print \"Directory(\"" + directory
					+ "\"):-" + command + "\" to initflashfiles.txt");
		}
	}
	
	// Write the header for the registry section.
	protected void writeRegistryHeader(String key)
	{
		try
		{
			rgu.write("\r\n[" + key + "]\r\n");
		}
		catch (IOException e)
		{
			System.out.println("Cannot add a " + key + " key to the rgu.");
		}		
	}

	// Write the entry for the registry key.
	protected void writeRegistryEntry(String key, String type, String value)
	{
		try
		{
			if(!key.equals("@"))
			{
				rgu.write("\"" + key + "\" = ");				
			}
			else
			{
				rgu.write(key + " = ");				
			}

			if(type.equalsIgnoreCase("integer"))
			{
				rgu.write("dword:" + String.format("%8s",Integer.toHexString(Integer.parseInt(value))).replaceAll("[\\s]", "0"));
			}
			else if(type.equalsIgnoreCase("binary"))
			{
				String hexValue = toHexString(new BASE64Decoder().decodeBuffer(value));
				rgu.write("hex:" + hexValue.substring(0,hexValue.length() - 1));
			}
			else if(type.equalsIgnoreCase("string"))
			{
				rgu.write("\"" + value + "\"");
			}
			
			rgu.write("\r\n");
		}
		catch (IOException e)
		{
			System.out.println("Cannot add a " + key + " key to the rgu.");
		}		
	}
	
	// Create the option.xml file.
	protected void createOptionXML(String oemName, String uuid, String appName)
	{
		if(appName != null)
		{
			System.out.print("Please enter the application name or press enter to name it \"" + appName + "\": ");
			String tempAppName = Keyboard.readString();
			appName = (tempAppName.equals("") ? appName : tempAppName);
		}
		else
		{
			System.out.print("Please enter the application name: ");
			appName = Keyboard.readString();
		}

		String group;
		do
		{
			System.out.print("Please enter the group this program belongs to: ");
			group = Keyboard.readString();			
		}
		while(group.equals(""));

		System.out.print("Please enter the tip for this program: ");
		String tip = Keyboard.readString();

		String checked;
		do
		{
			System.out.print("Should this program be checked by default? (yes/no): ");
			checked = Keyboard.readString();			
		}
		while(!checked.equalsIgnoreCase("yes") && !checked.equalsIgnoreCase("no"));
		checked = (checked.equalsIgnoreCase("yes") ? "true" : "false");
		
		try
		{
			BufferedWriter option = new BufferedWriter(new OutputStreamWriter(
					new FileOutputStream(oemName + "\\option.xml"),
					"UTF-16LE"));
			
			option.write("<?xml version=\"1.0\" encoding=\"UTF-16\" standalone=\"yes\"?>\n" +
						 "<Items>\n" +
						 "  <Item name=\"" + appName + "\" group=\"" + group + "\" checked=\"" + checked + "\">\n" +
						 "    <Tip>" + tip + "</Tip>\n" +
						 "    <Guid type=\"p\">" + uuid + "</Guid>\n" +
						 "  </Item>\n" +
						 "</Items>\n");
			
			option.close();
		}
		catch (FileNotFoundException e)
		{
			System.out.println("Option.xml not found, this shouldn't actually be possible.");
		}
		catch (UnsupportedEncodingException e)
		{
			System.out.println("Cannot create option.xml.");
		}
		catch (IOException e)
		{
			System.out.println("Cannot write to option.xml.");
		}
	}
}
