package oemMaker;

import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;

import keyboardPackage.Keyboard;

public class BinaryCabType extends CabType
{
	public BinaryCabType(String oemName, String uuid)
	{
		super(oemName, uuid);
	}

	// Create all the shortcuts.
	private void readShortcuts(String[] filenames, String[] directories, String[] strings, int numberOfShortcuts, FileReader file) throws IOException
	{
		
		for (int shortcutNumber = 0; shortcutNumber < numberOfShortcuts; shortcutNumber++)
		{
			file.skip(2);
			int dirID = file.read();
			boolean isCEVariable = false;
			
			if(dirID == 0)
			{
				isCEVariable = true;
				file.skip(1);
				dirID = file.read();
			}
			else
			{
				file.skip(2);
			}

			file.skip(1);
			int targetFileID = file.read();
			file.skip(5);
			int shortcutNameID = file.read();
			file.skip(1);
			
			String directory = (isCEVariable ? parameters.get("CE" + dirID) : directories[dirID]);
			
			System.out.println("Creating shortcut " + directory + "\\" + strings[shortcutNameID] + " pointing to " + filenames[targetFileID]);
			createShortcut(oemName + "\\" + strings[shortcutNameID], filenames[targetFileID]);
			writeInitFlashFile(directory, "File(\"" + strings[shortcutNameID] + "\",\"\\Windows\\" + strings[shortcutNameID] + "\")");

		}
	}
	
	// Process the file.
	public boolean processFile(String setupFilename)
	{
		// Load the file into a buffer.
		FileReader setupFileStream;
		try
		{
			setupFileStream = new FileReader(setupFilename);
		}
		catch (IOException e)
		{
			System.out.println("Error processing the cab, failed opening the setup file.");
			return false;
		}

		// It tells us how many of everything there is, so might as well save
		// it.
		int numberOfStrings;
		int numberOfDirectories;
		int numberOfFiles;
		int numberOfHives;
		int numberOfKeys;
		int numberOfShortcuts;

		try
		{
			// Skip over to the count area.
			setupFileStream.skip(48);

			numberOfStrings = setupFileStream.read(); setupFileStream.skip(1);
			numberOfDirectories = setupFileStream.read(); setupFileStream.skip(1);
			numberOfFiles = setupFileStream.read(); setupFileStream.skip(1);
			numberOfHives = setupFileStream.read(); setupFileStream.skip(1);
			numberOfKeys = setupFileStream.read(); setupFileStream.skip(1);
			numberOfShortcuts = setupFileStream.read();	setupFileStream.skip(1);
		}
		catch (IOException e)
		{
			System.out.println("Cannot determine the count.");
			return false;
		}

		// Other useful information.
		String appName;
		String author;
		String[] strings = new String[numberOfStrings + 1];
		String[] directories = new String[numberOfDirectories + 1];
		String[] filenames = new String[numberOfFiles + 1];
		String[] hives = new String[numberOfHives + 1];

		// Get the unsupported platforms.
		try
		{
			// Read the application name, author, and read past the unsupported platforms.
			setupFileStream.skip(40);
			appName = readValue(setupFileStream);
			author = readValue(setupFileStream);
			readUnsupportedPlatforms(setupFileStream);

			// Read the strings and then correct them. 
			readStrings(strings, setupFileStream);
			userStringsCorrection(strings);
			parameters.put("InstallDir", strings[1]); // Add the install dir.
			
			// Read the other things.
			readDirectories(directories, strings, setupFileStream);
			readFiles(filenames, directories, numberOfFiles, setupFileStream);
			readHives(hives, strings, setupFileStream);
			readRegistryKeys(hives, strings, numberOfKeys, setupFileStream);
			readShortcuts(filenames, directories, strings, numberOfShortcuts, setupFileStream);
			
			setupFileStream.close();
			initflashfiles.close();
			rgu.close();

			// Delete the orig directory.
			deleteDir(new File(oemName + "\\orig"));
			
			// Create the option.xml.
			createOptionXML(oemName, uuid, appName);
			
			return true;
		}
		catch (IOException e)
		{
			System.out.println("Cannot process the cab properly.");
			return false;
		}
	}

	// Loop through the string sections.
	private void readDirectories(String[] directories, String[] strings, FileReader file) throws IOException
	{
		for (int dirNumber = 1; dirNumber < directories.length; dirNumber++)
		{
			int dirID = file.read();
			file.skip(1);
			int dirLength = file.read();
			file.skip(1);

			String string = "";
			int character = file.read();
			for (int i = 1; i < dirLength / 2; i++)
			{
				string += strings[character] + "\\";
				file.skip(1);
				character = file.read();
			}
			file.skip(1);

			directories[dirID] = string.substring(0, string.length() - 1);
		}
		
		// Write them to the initflashfile in the correct order.
		for (int i = 1; i < directories.length; i++ )
		{
			System.out.println("Setting directory " + directories[i] + " to be created.");
			writeInitFlashFile("\\", "Directory(\"" + directories[i] + "\")");
		}
	}

	// Loop through the file sections.
	private void readFiles(String[] filenames, String[] directories, int numberOfFiles,
			FileReader file) throws IOException
	{
		for (int fileNumber = 0; fileNumber < numberOfFiles; fileNumber++)
		{
			int fileID = file.read();
			file.skip(1);
			int dirID = file.read();
			file.skip(7);
			int stringLength = file.read();
			file.skip(1);

			String string = "";
			int character = file.read();
			for (int i = 1; i < stringLength; i++)
			{
				string += (char) character;
				character = file.read();
			}

			renameFile(directories[dirID], String.format("%3d", fileID)
					.replace(' ', '0'), string);
			filenames[fileID] = directories[dirID] + "\\" + string;
		}
	}

	// Loop through the hives section.
	private void readHives(String[] hives, String[] strings, FileReader file) throws IOException
	{
		for (int hiveNumber = 1; hiveNumber < hives.length; hiveNumber++)
		{
			int hiveID = file.read();
			file.skip(1);
			String root = (file.read() == 1 ? "HKEY_CLASSES_ROOT" : "HKEY_LOCAL_MACHINE" );
			file.skip(5);

			String string = root + "\\";
			int character = file.read();
			while(character != 0 && character != -1)
			{
				string += strings[character] + "\\";
				file.skip(1);
				character = file.read();
			}

			file.skip(1);
			hives[hiveID] = string.substring(0, string.length() - 1).trim();
		}
	}

	// Loop through the registry keys.
	private void readRegistryKeys(String[] hives, String[] strings, int numberOfKeys, FileReader file) throws IOException
	{
		int lastHiveUsed = -1;
		for (int keyNumber = 0; keyNumber < numberOfKeys; keyNumber++)
		{
			file.skip(2);
			int hive = file.read(); file.skip(7);
			if(hive != lastHiveUsed) 
			{
				System.out.println("Adding registry header: " + hives[hive]);
				writeRegistryHeader(hives[hive]);
				lastHiveUsed = hive;
			}
			
			int stringLength = file.read(); file.skip(1);
			
			String string = "";
			int character = file.read();			
			for (int i = 1; i < stringLength; i++)
			{
				string += (char) character;
				character = file.read();
			}
			
			String key;
			String value;			
			if(string.charAt(0) == (char)0)
			{
				key = "@";
				value = string.substring(1);
			}
			else
			{
				key = string.split("" + (char)0)[0];
				value = string.split("" + (char)0)[1];
			}
			
			value = parameters.replaceVariables(value);
			
			System.out.println("Adding registry entry: " + key + " -> " + value);
			writeRegistryEntry(key, "string", value.replace("\\","\\\\"));
		}
	}

	// Loop through the string sections.
	private void readStrings(String[] strings, FileReader file)
			throws IOException
	{
		for (int stringNumber = 1; stringNumber < strings.length; stringNumber++)
		{
			int stringID = file.read();
			file.skip(1);
			int stringLength = file.read();
			file.skip(1);

			String string = "";
			int character = file.read();
			for (int i = 1; i < stringLength; i++)
			{
				string += (char) character;
				character = file.read();
			}

			strings[stringID] = parameters.replaceVariables(string);
		}
	}

	// Loop through the unsupported platforms, no need to save them.
	private void readUnsupportedPlatforms(FileReader file) throws IOException
	{
		int character = file.read();
		while (character != 0)
		{
			character = file.read();
			while (character != 0)
			{
				character = file.read();
			}

			character = file.read();
		}
	}

	// Loop through the file until reaching a 0 or the end of the file, then
	// return whatever is found.
	private String readValue(FileReader file) throws IOException
	{
		String string = "";

		int character = file.read();
		while (character != 0 && character != -1)
		{
			string += (char) character;
			character = file.read();
		}

		return string;
	}

	// Rename a file and add it to the initflashfile.
	private void renameFile(String workingDirectory, String extension,
			String target)
	{
		String subject = new File(oemName + "\\orig\\")
				.list(new FileFilter("", extension.toString()))[0];
		System.out.println("Renaming " + subject + " to " + target + ".");
		new File(oemName + "\\orig\\" + subject).renameTo(new File(oemName
				+ "\\" + target));
		writeInitFlashFile(workingDirectory, "File(\"" + target
				+ "\",\"\\Windows\\" + target + "\")");
	}

	// Allows the user to correct the parameters.
	private void userStringsCorrection(String[] strings)
	{
		// Output the directions.
		System.out
				.println("I'm going to output all the strings, and let you correct the ones you want.\n");

		// Run the loop.
		int selected;
		do
		{
			// Output the parameters.
			for (int i = 1; i < strings.length; i++)
			{
				System.out.println(i + ") " + strings[i]);
			}

			System.out
					.print("\nEnter the number you want to correct or enter -1 to continue: ");
			selected = Keyboard.readInt();

			// Determine if they selected a valid variable.
			if (selected > 0 && selected < strings.length)
			{
				System.out.print("Enter the new value for " + strings[selected]
						+ ": ");
				strings[selected] = Keyboard.readString();
			}
			else if (selected >= strings.length)
			{
				System.out.println("That number is too big.");
			}
		}
		while (selected != -1);
	}
}

class FileFilter implements FilenameFilter
{
	private String prefix;
	private String suffix;

	public FileFilter(String prefix, String suffix)
	{
		this.prefix = prefix;
		this.suffix = suffix;
	}

	public boolean accept(File dir, String name)
	{
		return name.startsWith(prefix) && name.endsWith(suffix);
	}
}
