package keyboardPackage;

import java.io.*;
import java.text.*;
import java.util.*;

public class Keyboard
{
	public static String readString()
	{
		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		String s = null;
		try
		{
			s = br.readLine();
		}
		catch (IOException e)
		{
			System.out.println("IOException");
		}
		return s.trim();
	}

	public static int readInt()
	{
		int i;
		for (;;)
		{
			String s = readString();
			try
			{
				i = Integer.parseInt(s);
			}
			catch (NumberFormatException nfe)
			{
				System.out.println("Invalid integer, try again");
				continue;
			}
			break;
		}
		return i;
	}

	public static double readDouble()
	{
		double d;
		for (;;)
		{
			String s = readString();
			try
			{
				DecimalFormat df = new DecimalFormat();
				Number n = df.parse(s);
				d = n.doubleValue();
			}
			catch (ParseException e)
			{
				System.out.println("Invalid double, try again");
				continue;
			}
			break;
		}
		return d;
	}

	public static int[] readArray()
	{
		int[] list;
		for (;;)
		{
			StringTokenizer st = new StringTokenizer(readString(), ",");
			list = new int[st.countTokens()];
			int i = 0;
			try
			{
				while (st.hasMoreTokens())
				{
					list[i] = Integer.parseInt(st.nextToken());
					i++;
				}
			}
			catch (NumberFormatException nfe)
			{
				System.out
						.println("Invalid list; separate elements with commas and try again");
				continue;
			}
			break;
		}
		return list;
	}
}
